/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client;

import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.IEditing;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EditingTracker {
    private IModConfig editingConfig;
    private static EditingTracker instance;

    public static EditingTracker instance() {
        if (instance == null) {
            instance = new EditingTracker();
        }
        return instance;
    }

    private EditingTracker() {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onScreenOpen(ScreenOpenEvent event) {
        Screen screen = event.getScreen();
        if (screen instanceof IEditing) {
            IEditing editing = (IEditing)screen;
            if (this.editingConfig == null) {
                this.editingConfig = editing.getActiveConfig();
                this.editingConfig.startEditing();
                Configured.LOGGER.info("Started editing '" + this.editingConfig.getFileName() + "'");
            } else {
                if (editing.getActiveConfig() == null) {
                    throw new NullPointerException("A null config was returned when getting active config");
                }
                if (this.editingConfig != editing.getActiveConfig()) {
                    throw new IllegalStateException("Trying to edit a config while one is already loaded. This should not happen!");
                }
            }
        } else if (this.editingConfig != null) {
            Configured.LOGGER.info("Stopped editing '" + this.editingConfig.getFileName() + "'");
            this.editingConfig.stopEditing();
            this.editingConfig = null;
        }
    }
}

